<?php echo $__env->make('frontend.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<body style="background-color: #666666;">
    
    <div class="limiter">
        <div class="container-login100">
            <div class="wrap-login100">

                <form class="register-form validate-form" action="/register" method="POST" enctype="">
                    <?php echo csrf_field(); ?>
                        
                    <span class="login100-form-title p-b-43">
                        <div class="row m-t-5 m-b-20 ">
                            <div class="col-lg-8 offset-2 text-center m-l-r-auto">
                                <img src="<?php echo e(asset('frontend/images/logo.png')); ?>">
                            </div>
                        </div>
                        Create an Account Now
                        <h6>
                            <?php if(session('status')): ?>
                                <div class="alert alert-<?php echo e(session('status')['type']); ?>">
                                    <?php echo e(session('status')['text']); ?>

                                </div>
                            <?php endif; ?>
                        </h6>
                    </span>
                    
                    <div class="wrap-input100 validate-input" data-validate = "First Name is Required">
                        <?php if($errors->has('first_name')): ?>
                            <span class="text-danger"><?php echo e($errors->first('first_name')); ?></span>
                        <?php endif; ?>
                        <input class="input100" type="text" name="first_name" value="<?php echo e(old('first_name')); ?>">
                        <span class="focus-input100"></span>
                        <span class="label-input100">First Name</span>
                    </div>

                    <div class="wrap-input100 validate-input" data-validate = "Last Name is Required">
                        <?php if($errors->has('last_name')): ?>
                            <span class="text-danger"><?php echo e($errors->first('last_name')); ?></span>
                        <?php endif; ?>
                        <input class="input100" type="text" name="last_name" value="<?php echo e(old('last_name')); ?>">
                        <span class="focus-input100"></span>
                        <span class="label-input100">Last Name</span>
                    </div>

                    <div class="wrap-input100 validate-input" data-validate = "Date of Birth is Required">
                        <input class="input100" type="date" name="dob" value="<?php echo e(old('dob')); ?>">
                        <span class="focus-input100"></span>
                        <span class="label-input100"></span>
                    </div>

                    <div class="wrap-input100 validate-input" data-validate = "Phone is Required">
                        <?php if($errors->has('phone')): ?>
                            <span class="text-danger"><?php echo e($errors->first('phone')); ?></span>
                        <?php endif; ?>
                        <input class="input100" type="text" name="phone" value="<?php echo e(old('phone')); ?>">
                        <span class="focus-input100"></span>
                        <span class="label-input100">Phone Number</span>
                    </div>

                    <div class="wrap-input100 validate-input" data-validate = "Account Type is Required">
                        <?php if($errors->has('acc_type')): ?>
                            <span class="text-danger"><?php echo e($errors->first('acc_type')); ?></span>
                        <?php endif; ?>
                        <select class="input100" name="acc_type" required>
                            <option value="">Select Account Type</option>
                            <option value="Savings">Savings</option>
                            <option value="Cooperate">Cooperate</option>
                            <option value="Current">Current</option>
                            <option value="Account Checking">Account Checking</option>
                        </select>
                        
                    </div>

                    <div class="wrap-input100 validate-input" data-validate = "Currency is Required">
                        <?php if($errors->has('currency')): ?>
                            <span class="text-danger"><?php echo e($errors->first('currency')); ?></span>
                        <?php endif; ?>
                        <select class="input100" name="currency" required>
                            <option value="">Select Currency</option>
                            <option value="USD">USD</option>
                            <option value="EUR">EUR</option>
                            <option value="GBP">GBP</option>
                        </select>
                        
                    </div>

                    
                    <div class="wrap-input100 validate-input" data-validate = "Valid email is required: ex@abc.xyz">
                        <?php if($errors->has('email')): ?>
                                    <span class="text-danger"><?php echo e($errors->first('email')); ?></span>
                                <?php endif; ?>
                        <input class="input100" type="text" name="email" value="<?php echo e(old('email')); ?>">
                        <span class="focus-input100"></span>
                        <span class="label-input100">Email</span>
                    </div>
                    
                    
                    <div class="wrap-input100 validate-input" data-validate="Password is required">
                        <?php if($errors->has('password')): ?>
                            <span class="text-danger"><?php echo e($errors->first('password')); ?></span>
                        <?php endif; ?>
                        <input class="input100" type="password" name="password" value="<?php echo e(old('password')); ?>">
                        <span class="focus-input100"></span>
                        <span class="label-input100">Password</span>
                    </div>

        

                    <div class="container-login100-form-btn p-t-20">
                        <button class="login100-form-btn">
                            Create an Account
                        </button>
                    </div>
                    
                    <div class="text-center p-t-46 p-b-20">
                        <span class="txt2">
                            Already have an account? <br> <a href="/">Login Here</a>
                        </span>
                    </div>

                    
                </form>

                <div class="login100-more" style="background-image: url('<?php echo e(asset('frontend/images/bg.jpg')); ?> ')  ;">
                </div>
            </div>
        </div>
    </div>
    
    
<?php echo $__env->make('frontend.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    
<?php /**PATH /home/unithjxh/online.enloeb.com/bankdash/resources/views/frontend/register.blade.php ENDPATH**/ ?>