<?php echo $__env->make('backend.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('backend.layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<main id="main" class="main">

<div class="pagetitle">
  <h1>All Users</h1>

</div><!-- End Page Title -->

<section class="section">
  <div class="row">


    <div class="col-lg-12">

      <div class="card">
        <div class="card-body">
          <h5 class="card-title">All Users</h5>

          <?php if(session('status')): ?>
              <div class="alert alert-<?php echo e(session('status')['type']); ?>">
                  <?php echo e(session('status')['text']); ?>

              </div>
          <?php endif; ?>
          <!-- Table with stripped rows -->
          <div class="table-responsive">
          <table class="table table-striped">
            <thead>
              <tr>
                <th scope="col">Name</th>
                <th scope="col">A/C Type</th>
                <th scope="col">A/C Number</th>
                <th scope="col">Balance</th>
                <th scope="col">Edit</th>
                <th scope="col">Transaction</th>
                <th scope="col">Action</th>
                <th scope="col">Delete</th>
              </tr>
            </thead>
            <tbody>
            <?php $__currentLoopData = $user; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e($row->first_name); ?> <?php echo e($row->last_name); ?></td>
                <td><?php echo e($row->acc_type); ?></td>
                <td><?php echo e($row->acc_number); ?> </td>
                <td>$<?php echo e(number_format($row->balance, 2, '.', ',')); ?> </td>
                <td><a href="/admin/edit-user/<?php echo e($row->user_id); ?>" >Edit</a></td>
                <td><a href="/admin/view-user/<?php echo e($row->user_id); ?>">View Transactions</a></td>
                <td>
                  <form class="form-horizontal" action="/admin/change-status/<?php echo e($row->user_id); ?>" method="post" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <select name="acc_status">
                        <option value="Active" <?php echo ($row['acc_status']=='Active') ? "selected" : ""; ?>>Active</option>
                        <option value="Dormant" <?php echo ($row['acc_status']=='Dormant') ? "selected" : ""; ?>>Dormant</option>
                        <option value="Blocked" <?php echo ($row['acc_status']=='Blocked') ? "selected" : ""; ?>>Blocked</option>
                          <option value="Frozen" <?php echo ($row['acc_status']=='Frozen') ? "selected" : ""; ?>>Frozen</option>
                    </select>
                    <input type="submit" name="submit" value="Change Status">
                </form>
                </td>
         
                <td><a href="/admin/delete-user/<?php echo e($row->user_id); ?>" onclick="return confirm('Are you sure you want to delete User?');">Delete</a></td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              
            </tbody>
          </table>
          </div>
          <!-- End Table with stripped rows -->

<div class="pagination-box text-center mt-50">
  <br>
    <nav aria-label="Page navigation example">
        <ul class="pagination">
            <?php echo $user->links(); ?>

        </ul>
    </nav>
</div>

        </div>
      </div>

      



    </div>
  </div>
</section>

</main><!-- End #main -->
<script>
function myFunction() {
  confirm("Are you sure you want to delete?");
}
</script>
<?php echo $__env->make('backend.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/www/laravel/bankdash/resources/views/backend/users/users.blade.php ENDPATH**/ ?>