<?php echo $__env->make('backend.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('backend.layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script src="<?php echo e(asset('backend/js/bootstrap.bundle.min.js')); ?>"></script>
<script src="<?php echo e(asset('backend/js/jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset('tinymce/tinymce.min.js')); ?>"></script>
<script src="<?php echo e(asset('tinymce/jquery.tinymce.min.js')); ?>"></script>



<main id="main" class="main">

    <div class="pagetitle">
    <h1>User Details</h1>
  
    </div><!-- End Page Title -->

    <section class="section">
    <div class="row">
    <div class="col-lg-12">
    
        <div class="card">
        <div class="card-body">
            <h5 class="card-title">User Details</h5>
            <h6 ><strong>Name:</strong> <?php echo e($user->first_name); ?> <?php echo e($user->last_name); ?></h6>
            <h6 ><strong>Email:</strong> <?php echo e($user->email); ?> </h6>
            <h6 ><strong>Account Type:</strong> <?php echo e($user->acc_type); ?> </h6>
            <h6 ><strong>Balance:</strong> <?php echo e(number_format($user->balance, 2, '.', ',')); ?> <?php echo e($user->currency); ?> </h6>
            
    
        </div>
        </div>
    
    </div>
    
    </div>
    </section>

    <section class="section">
    <div class="row">
    <div class="col-lg-12">
    
        <div class="card">
        <div class="card-body">
            <h5 class="card-title">Credit Transactions</h5>
            <!-- Table with stripped rows -->
          <div class="table-responsive">
          <table class="table table-striped">
            <thead>
              <tr>
                <th scope="col">Trans ID</th>
                <th scope="col">Trans Type</th>
                <th scope="col">Amount</th>
                <th scope="col">Trans Description</th>
                <th scope="col">Date of Trans</th>
                <th scope="col">Delete</th>
              </tr>
            </thead>
            <tbody>
            <?php $__currentLoopData = $credit; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e($row->trans_id); ?></td>
                <td><?php echo e($row->trans_type); ?></td>
                <td><?php echo e(number_format($row->amount, 2, '.', ',')); ?> </td>
                <td><?php echo e($row->trans_des); ?> </td>
                <td><?php echo e(date('j F Y', strtotime($row->dot))); ?></td>
                <td><a href="/admin/delete-trans/<?php echo e($row->trans_id); ?>/<?php echo e($row->user_id); ?>" onclick="return confirm('Are you sure you want to delete Transaction?');">Delete</a></td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              
            </tbody>
          </table>
          </div>
        </div>
        </div>
    
    </div>
    
    </div>
    </section>

    <section class="section">
    <div class="row">
    <div class="col-lg-12">
    
        <div class="card">
        <div class="card-body">
            <h5 class="card-title">Debit Transactions</h5>
            <!-- Table with stripped rows -->
          <div class="table-responsive">
          <table class="table table-striped">
            <thead>
              <tr>
                <th scope="col">Trans ID</th>
                <th scope="col">Trans Type</th>
                <th scope="col">Amount</th>
                <th scope="col">A/C Number</th>
                <th scope="col">Trans Description</th>
                <th scope="col">Date of Trans</th>
                <th scope="col">Delete</th>
              </tr>
            </thead>
            <tbody>
            <?php $__currentLoopData = $debit; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e($row->trans_id); ?></td>
                <td><?php echo e($row->trans_type); ?></td>
                <td><?php echo e(number_format($row->amount, 2, '.', ',')); ?> </td>
                <td><?php echo e($row->acc_number); ?> </td>
                <td><?php echo e($row->trans_des); ?> </td>
                <td><?php echo e(date('j F Y', strtotime($row->dot))); ?></td>
                <td><a href="/admin/delete-trans/<?php echo e($row->trans_id); ?>/<?php echo e($row->user_id); ?>" onclick="return confirm('Are you sure you want to delete Transaction?');">Delete</a></td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              
            </tbody>
          </table>
          </div>
        </div>
        </div>
    
    </div>
    
    </div>
    </section>

    <section class="section">
    <div class="row">
    <div class="col-lg-12">
    
        <div class="card">
        <div class="card-body">
            <h5 class="card-title">Add Transaction</h5>
            <?php if(session('balance-status')): ?>
                <div class="alert alert-<?php echo e(session('status')['type']); ?>">
                    <?php echo e(session('status')['text']); ?>

                </div>
            <?php endif; ?>
            <!-- General Form Elements -->
            <form action="/admin/new-trans/<?php echo e($user->user_id); ?>" method="POST" role="form">
             <?php echo csrf_field(); ?>

             <div class="row col-sm-12 mb-2">
                <label for="inputText" class=" col-form-label">Account Type:</label>
                <div class="">
                    <?php if($errors->has('trans_type')): ?>
                        <span class="text-danger"><?php echo e($errors->first('trans_type')); ?></span>
                    <?php endif; ?>
                <select name="trans_type" class="form-select" aria-label="Default select example" required>
                    <option value="">Select Transaction</option>
                    <option value="Credit">Credit</option>
                    <option value="Debit">Debit</option>
                    <option value="Pending">Pending</option>
                </select>
                </div>
            </div>

    
            <div class="row col-sm-12 mb-3">
                <label for="inputText" class=" col-form-label">Amount</label>
                <div class="">
                    <?php if($errors->has('amount')): ?>
                        <span class="text-danger"><?php echo e($errors->first('amount')); ?></span>
                    <?php endif; ?>
                <input type="number" name="amount" class="form-control" min="1" maxlength="11" step=".01" value="<?php echo e(old('amount')); ?>" required>
                </div>
            </div>


            <div class="row col-sm-12 mb-2">
                <label for="inputText" class=" col-form-label">Date of Transaction:</label>
                <div class="">
                    <?php if($errors->has('dot')): ?>
                        <span class="text-danger"><?php echo e($errors->first('dot')); ?></span>
                    <?php endif; ?>
                <input type="date" name="dot" class="form-control" placeholder="Date of birth" value="<?php echo e(old('dot')); ?>" required>
                </div>
            </div>

            <div class="row col-sm-12 mb-2">
                <label for="inputText" class=" col-form-label">Transaction Description:</label>
                <div class="">
                    <?php if($errors->has('trans_des')): ?>
                        <span class="text-danger"><?php echo e($errors->first('trans_des')); ?></span>
                    <?php endif; ?>
                <textarea class="form-control" name="trans_des" required placeholder="Transaction Description"></textarea>
                </div>
            </div>

            <div class="row mb-3">
                <label class="col-sm-2 col-form-label"></label>
                <div class="col-sm-10">
                <button type="submit" class="btn btn-primary">Submit</button>
                </div>
            </div>
    
            </form><!-- End General Form Elements -->
    
        </div>
        </div>
    
    </div>
    
    </div>
    </section>

    
    


    
    </main><!-- End #main -->

    <?php echo $__env->make('backend.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/unithjxh/online.enloeb.com/bankdash/resources/views/backend/users/view-user.blade.php ENDPATH**/ ?>