@include('dashboard.layouts.header')
@include('dashboard.layouts.nav')
<script src="{{ asset('backend/js/jquery.min.js') }}"></script>


<!-- content @s -->
<div class="nk-content nk-content-lg nk-content-fluid pt-100">
    <div class="container-xl wide-lg">
        <div class="nk-content-inner">
            <div class="nk-content-body">
                <div class="kyc-app wide-sm m-auto">
                    <div class="nk-block-head nk-block-head-lg wide-xs mx-auto">
                        <div class="nk-block-head-content text-center">
                            <h2 class="nk-block-title fw-normal">Withrawal Request</h2>
                            <div class="nk-block-des">
                                <p>
                                    @if(session('status'))
                                        <div class="alert alert-{{session('status')['type']}}">
                                            {{session('status')['text']}}
                                        </div>
                                    @endif
                                </p>
                            </div>
                        </div>
                    </div><!-- nk-block -->
                    <div class="nk-block">
                        <div class="card card-bordered">
                            <div class="nk-kycfm">
                                <div class="nk-kycfm-head">
                                    <div class="nk-kycfm-count">01</div>
                                    <div class="nk-kycfm-title">
                                        <h5 class="title">Withdrawal Details</h5>
                                        <p class="sub-title">Please all the fields are required</p>
                                    </div>
                                </div><!-- nk-kycfm-head -->
                                <div class="nk-kycfm-content">
                                   <form action="/user/withdraw" method="POST">
                                    @csrf
                                    <div class="row g-4">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <div class="form-label-group">
                                                    <label class="form-label">Amount <span class="text-danger">*</span></label>
                                                </div>
                                                <div class="form-control-group">
                                                    <input type="text" name="amount" class="form-control form-control-lg" maxlength="11" pattern="[0-9]*" value="{{ old('amount') }}" required>
                                                </div>
                                            </div>
                                        </div><!-- .col -->
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <div class="form-label-group">
                                                    <label class="form-label">Wallet Address <span class="text-danger">*</span></label>
                                                </div>
                                                <div class="form-control-group">
                                                    <input type="text" name="wallet" class="form-control form-control-lg" value="{{ old('wallet') }}" required>
                                                </div>
                                            </div>
                                        </div><!-- .col -->
                                        
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <div class="form-label-group">
                                                    <label class="form-label">Account Password <span class="text-danger">*</span></label>
                                                </div>
                                                @if ($errors->has('password'))
                                                    <span class="text-danger">{{ $errors->first('password') }}</span>
                                                @endif
                                                <div class="form-control-group">
                                                    <input type="password" name="password" class="form-control form-control-lg" value="{{ old('password') }}" required>
                                                </div>
                                            </div>
                                        </div><!-- .col -->
                                        
                            
                                    </div><!-- .row -->
                                </div><!-- nk-kycfm-content -->
                           
                         
                                <div class="nk-kycfm-footer">
                            
                              
                                    <div class="nk-kycfm-action pt-2">
                                        <button type="submit" class="btn btn-lg btn-primary">Submit Request</button>
                                    </div>
                                </form>
                                </div><!-- nk-kycfm-footer -->
                            </div><!-- nk-kycfm -->
                        </div><!-- .card -->
                    </div><!-- nk-block -->
                </div><!-- .kyc-app -->
            </div>
        </div>
    </div>
</div>
<!-- content @e -->

@include('dashboard.layouts.footer')