@include('dashboard.layouts.header')
@include('dashboard.layouts.sidebar')
@include('dashboard.layouts.nav')


<!-- content @s -->
<div class="nk-content nk-content-fluid">
    <div class="container-xl wide-lg">
        <div class="nk-content-body">
            
            <div class="nk-block nk-block-lg">
                <div class="nk-block-head">
                    <div class="nk-block-head-content">
                        <h4 class="title nk-block-title">Transfer to another {{ config('global.site_name') }} Account</h4>
                        <div class="nk-block-des">
                            <p>You can monitor your account activity 24 hours a day. you can access your statement, check your account balance, review deposits and withdrawals and transfer funds. Our Electronic Funds Transfer (ETF) allows you to move money from one acount to another.</p>
                        </div>
                    </div>
                </div>
                <div class="card card-bordered">
                    <div class="card-inner">
                        <div class="card-head">
                            <h5 class="card-title">Transfer Details</h5>
                        </div>
                        <form action="/user/local-transfer" method="POST">
                            @csrf
                            <div class="row g-4">
                                <div class="col-lg-12">
                                    @if(session('status'))
                                        <div class="alert alert-{{session('status')['type']}}">
                                            {{session('status')['text']}}
                                        </div>
                                    @endif
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label class="form-label" for="full-name-1">Account Number <span class="text-danger">*</span> </label>
                                        <div class="form-control-wrap">
                                            <input type="text" class="form-control" name="acc_number" required value="{{ old('acc_number') }}">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label class="form-label" for="email-address-1">Amount ({{ $user->currency }})<span class="text-danger">*</span></label>
                                        <div class="form-control-wrap">
                                            <input type="number" class="form-control" name="amount" required value="{{ old('amount') }}">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label class="form-label" for="phone-no-1">Description <span class="text-danger">*</span></label>
                                        <div class="form-control-wrap">
                                            <textarea class="form-control" name="trans_des" required>{{ old('trans_des') }}</textarea>
                                            
                                        </div>
                                    </div>
                                </div>
                                
                              
                                <div class="col-12">
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-lg btn-primary">Submit</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div><!-- .nk-block -->

        </div>
    </div>
</div>
<!-- content @e -->





@include('dashboard.layouts.footer')