@include('dashboard.layouts.header')
@include('dashboard.layouts.nav')
<script src="{{ asset('backend/js/jquery.min.js') }}"></script>


<!-- content @s -->
<div class="nk-content nk-content-lg nk-content-fluid">
    <div class="container-xl wide-lg">
        <div class="nk-content-inner">
            <div class="nk-content-body">
                <div class="nk-block-head nk-block-head-lg">
                    <div class="nk-block-head-content">
                        <div class="nk-block-head-sub"><a href="/user/plan" class="back-to"><em class="icon ni ni-arrow-left"></em><span>Back to plan</span></a></div>
                        <div class="nk-block-head-content">
                            <h2 class="nk-block-title fw-normal">Ready to get started?</h2>
                        </div>
                    </div>
                </div><!-- nk-block-head -->
                <div class="nk-block invest-block">
                    <form action="/user/payment" class="invest-form" method="POST">
                        @csrf
                        <div class="row g-gs">
                            <div class="col-lg-7">
                                <div class="invest-field form-group">
                                    <input type="hidden" value="silver" name="iv-plan" id="invest-choose-plan">
                                    <div class="dropdown invest-cc-dropdown">
                                        <a href="#" class="invest-cc-chosen dropdown-indicator" data-toggle="dropdown">
                                            <div class="coin-item">
                                                <div class="coin-icon">
                                                    <em class="icon ni ni-offer-fill"></em>
                                                </div>
                                                <div class="coin-info">
                                                    <span class="coin-name">{{ $plan->plan }} Plan</span>
                                                    <span class="coin-text">Invest for {{ $plan->num_days }} days and get daily profit {{ $plan->interest }}%</span>
                                                </div>
                                            </div>
                                        </a>
                                       
                                    </div><!-- .dropdown -->
                                </div><!-- .invest-field -->
                           
                                <div class="invest-field form-group">
                                    <div class="form-label-group">
                                        <label class="form-label"> Enter Your Amount</label>
                                        <div class="dropdown">
                                           
                                        </div>
                                    </div>
                                    <div>
                                        @if(session('status'))
                                            <div class="alert alert-{{session('status')['type']}}">
                                                {{session('status')['text']}}
                                            </div>
                                        @endif
                                    </div>
                                    <div class="form-control-group">
                                        <div class="form-info">USD</div>
                                        <input type="hidden" name="plan" value="{{ $plan->plan_id }}">

                                        <input type="number" class="form-control form-control-amount form-control-lg" id="custom-amount" name="amount" placeholder="${{ $plan->min_deposit }}" min="{{ $plan->min_deposit }}" max="{{ $plan->max_deposit }}" onKeyup="myFunction()" required>
                                        
                                    </div>
                                    <div class="form-note pt-2">Note: Minimum invest {{ $plan->min_deposit }} USD and upto {{ $plan->max_deposit }} USD</div>
                                </div><!-- .invest-field -->
                                <div class="invest-field form-group">
                                    <div class="form-label-group">
                                        <label class="form-label">Payment Method</label>
                                    </div>
                                    <input type="hidden" value="wallet" name="iv-wallet" id="invest-choose-wallet">
                                    <div class="dropdown invest-cc-dropdown">
                                        <a  class="invest-cc-chosen dropdown-indicator" data-toggle="dropdown">
                                            <div class="coin-item">
                                                <div class="coin-icon">
                                                    <em class="icon ni ni-wallet-alt"></em>
                                                </div>
                                                <div class="coin-info">
                                                    <span class="coin-name">Bitcoin</span>
                                                    
                                                </div>
                                            </div>
                                        </a>
                                     
                                    </div><!-- .dropdown -->
                                </div><!-- .invest-field -->
                                <div class="invest-field form-group">
                                    <div class="custom-control custom-control-xs custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" id="checkbox" required>
                                        <label class="custom-control-label" for="checkbox">I agree the <a href="#">terms and &amp; conditions.</a></label>
                                    </div>
                                </div><!-- .invest-field -->
                            </div><!-- .col -->
                            <div class="col-xl-4 col-lg-5 offset-xl-1">
                                <div class="card card-bordered ml-lg-4 ml-xl-0">
                                    <div class="nk-iv-wg4">
                                        <div class="nk-iv-wg4-sub">
                                            <h6 class="nk-iv-wg4-title title">Your Investment Details</h6>
                                            <ul class="nk-iv-wg4-overview g-2">
                                                <li>
                                                    <div class="sub-text">Name of scheme</div>
                                                    <div class="lead-text">{{ $plan->plan }} Plan</div>
                                                </li>
                                                <li>
                                                    <div class="sub-text">Term of the scheme</div>
                                                    <div class="lead-text">{{ $plan->num_days }} days</div>
                                                </li>
                                                <li>
                                                    <div class="sub-text">Daily profit</div>
                                                    <div class="lead-text">{{ $plan->interest }} %</div>
                                                </li>
                                                <li>
                                                    <div class="sub-text">Total Return %</div>
                                                    <div class="lead-text">{{ $plan->total_return }} %</div>
                                                </li>
                                            
                                            
                                            </ul>
                                        </div><!-- .nk-iv-wg4-sub -->
                                        <div class="nk-iv-wg4-sub">
                                            <ul class="nk-iv-wg4-list">
                                                <li>
                                                    <div class="sub-text">Payment Method</div>
                                                    <div class="lead-text">Bitcoin</div>
                                                </li>
                                            </ul>
                                        </div><!-- .nk-iv-wg4-sub -->
                                   
                                        <div class="nk-iv-wg4-sub">
                                            <ul class="nk-iv-wg4-list">
                                                <li>
                                                    <div class="lead-text">Total Charge</div>
                                                    <div class="caption-text text-primary">$ <span id="demo"></span></div>
                                                </li>
                                            </ul>
                                        </div><!-- .nk-iv-wg4-sub -->
                                        <div class="nk-iv-wg4-sub text-center bg-lighter">
                                            <button class="btn btn-lg btn-primary ttu">Confirm &amp; proceed</button>
                                            
                                        </div><!-- .nk-iv-wg4-sub -->
                                    </div><!-- .nk-iv-wg4 -->
                                </div><!-- .card -->
                            </div><!-- .col -->
                        </div><!-- .row -->
                    </form>
                </div><!-- .nk-block -->
            </div>
        </div>
    </div>
</div>
<!-- content @e -->

<script type="text/javascript">
    function myFunction() {
    var val = document.getElementById("custom-amount").value;
    document.getElementById("demo").innerHTML = val;
}
</script>

@include('dashboard.layouts.footer')