@include('backend.layouts.header')
@include('backend.layouts.nav')

<script src="{{ asset('backend/js/bootstrap.bundle.min.js') }}"></script>
<script src="{{ asset('backend/js/jquery.min.js') }}"></script>
<script src="{{ asset('tinymce/tinymce.min.js') }}"></script>
<script src="{{ asset('tinymce/jquery.tinymce.min.js') }}"></script>



<main id="main" class="main">

    <div class="pagetitle">
    <h1>User Details</h1>
  
    </div><!-- End Page Title -->

    <section class="section">
    <div class="row">
    <div class="col-lg-12">
    
        <div class="card">
        <div class="card-body">
            <h5 class="card-title">User Details</h5>
            <h6 ><strong>Name:</strong> {{ $user->first_name }} {{ $user->last_name }}</h6>
            <h6 ><strong>Email:</strong> {{ $user->email }} </h6>
            <h6 ><strong>Account Type:</strong> {{ $user->acc_type }} </h6>
            <h6 ><strong>Balance:</strong> {{ number_format($user->balance, 2, '.', ',') }} {{ $user->currency }} </h6>
            
    
        </div>
        </div>
    
    </div>
    
    </div>
    </section>

    <section class="section">
    <div class="row">
    <div class="col-lg-12">
    
        <div class="card">
        <div class="card-body">
            <h5 class="card-title">Credit Transactions</h5>
            <!-- Table with stripped rows -->
          <div class="table-responsive">
          <table class="table table-striped">
            <thead>
              <tr>
                <th scope="col">Trans ID</th>
                <th scope="col">Trans Type</th>
                <th scope="col">Amount</th>
                <th scope="col">Trans Description</th>
                <th scope="col">Date of Trans</th>
                <th scope="col">Delete</th>
              </tr>
            </thead>
            <tbody>
            @foreach ( $credit as $row )
              <tr>
                <td>{{ $row->trans_id }}</td>
                <td>{{ $row->trans_type }}</td>
                <td>{{ number_format($row->amount, 2, '.', ',') }} </td>
                <td>{{ $row->trans_des }} </td>
                <td>{{ date('j F Y', strtotime($row->dot)); }}</td>
                <td><a href="/admin/delete-trans/{{ $row->trans_id }}/{{ $row->user_id }}" onclick="return confirm('Are you sure you want to delete Transaction?');">Delete</a></td>
              </tr>
            @endforeach
              
            </tbody>
          </table>
          </div>
        </div>
        </div>
    
    </div>
    
    </div>
    </section>

    <section class="section">
    <div class="row">
    <div class="col-lg-12">
    
        <div class="card">
        <div class="card-body">
            <h5 class="card-title">Debit Transactions</h5>
            <!-- Table with stripped rows -->
          <div class="table-responsive">
          <table class="table table-striped">
            <thead>
              <tr>
                <th scope="col">Trans ID</th>
                <th scope="col">Trans Type</th>
                <th scope="col">Amount</th>
                <th scope="col">A/C Number</th>
                <th scope="col">Trans Description</th>
                <th scope="col">Date of Trans</th>
                <th scope="col">Delete</th>
              </tr>
            </thead>
            <tbody>
            @foreach ( $debit as $row )
              <tr>
                <td>{{ $row->trans_id }}</td>
                <td>{{ $row->trans_type }}</td>
                <td>{{ number_format($row->amount, 2, '.', ',') }} </td>
                <td>{{ $row->acc_number }} </td>
                <td>{{ $row->trans_des }} </td>
                <td>{{ date('j F Y', strtotime($row->dot)); }}</td>
                <td><a href="/admin/delete-trans/{{ $row->trans_id }}/{{ $row->user_id }}" onclick="return confirm('Are you sure you want to delete Transaction?');">Delete</a></td>
              </tr>
            @endforeach
              
            </tbody>
          </table>
          </div>
        </div>
        </div>
    
    </div>
    
    </div>
    </section>

    <section class="section">
    <div class="row">
    <div class="col-lg-12">
    
        <div class="card">
        <div class="card-body">
            <h5 class="card-title">Add Transaction</h5>
            @if(session('balance-status'))
                <div class="alert alert-{{session('status')['type']}}">
                    {{session('status')['text']}}
                </div>
            @endif
            <!-- General Form Elements -->
            <form action="/admin/new-trans/{{ $user->user_id }}" method="POST" role="form">
             @csrf

             <div class="row col-sm-12 mb-2">
                <label for="inputText" class=" col-form-label">Account Type:</label>
                <div class="">
                    @if ($errors->has('trans_type'))
                        <span class="text-danger">{{ $errors->first('trans_type') }}</span>
                    @endif
                <select name="trans_type" class="form-select" aria-label="Default select example" required>
                    <option value="">Select Transaction</option>
                    <option value="Credit">Credit</option>
                    <option value="Debit">Debit</option>
                    <option value="Pending">Pending</option>
                </select>
                </div>
            </div>

    
            <div class="row col-sm-12 mb-3">
                <label for="inputText" class=" col-form-label">Amount</label>
                <div class="">
                    @if ($errors->has('amount'))
                        <span class="text-danger">{{ $errors->first('amount') }}</span>
                    @endif
                <input type="number" name="amount" class="form-control" min="1" maxlength="11" step=".01" value="{{ old('amount') }}" required>
                </div>
            </div>


            <div class="row col-sm-12 mb-2">
                <label for="inputText" class=" col-form-label">Date of Transaction:</label>
                <div class="">
                    @if ($errors->has('dot'))
                        <span class="text-danger">{{ $errors->first('dot') }}</span>
                    @endif
                <input type="date" name="dot" class="form-control" placeholder="Date of birth" value="{{ old('dot') }}" required>
                </div>
            </div>

            <div class="row col-sm-12 mb-2">
                <label for="inputText" class=" col-form-label">Transaction Description:</label>
                <div class="">
                    @if ($errors->has('trans_des'))
                        <span class="text-danger">{{ $errors->first('trans_des') }}</span>
                    @endif
                <textarea class="form-control" name="trans_des" required placeholder="Transaction Description"></textarea>
                </div>
            </div>

            <div class="row mb-3">
                <label class="col-sm-2 col-form-label"></label>
                <div class="col-sm-10">
                <button type="submit" class="btn btn-primary">Submit</button>
                </div>
            </div>
    
            </form><!-- End General Form Elements -->
    
        </div>
        </div>
    
    </div>
    
    </div>
    </section>

    
    


    
    </main><!-- End #main -->

    @include('backend.layouts.footer')