<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->increments('id');
            $table->string('user_id');
            $table->string('trans_id');
            $table->string('acc_number')->nullable();
            $table->string('acc_name')->nullable();
            $table->string('bank_name')->nullable();
            $table->string('trans_type');
            $table->string('amount');
            $table->text('trans_des');
            $table->text('address')->nullable();
            $table->string('country')->nullable();
            $table->string('dot');
            $table->string('swift_code')->nullable();
            $table->string('iban')->nullable();
            $table->string('trans_status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
